
/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件获取错误码语言翻译; 翻译表唯一key === "CODE"列
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2021.7.16
 *      内容 : 所有代码
 *************************************************************************************************/

/* global $ */
/* global Papa */

/* exported mc_ui_lang_error_code */

/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    解析错误码翻译表
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-07-17
 *       内容 : 所有代码
************************************************************************************************/
function mc_ui_lang_error_code() {
    // 数据map
    var m_obj_map = {};
    // 存储头部信息; 语言列表 ["中文", "English"]
    var m_arr_header = [];
    // 当前语言类型
    var m_str_cur_lang_type = "中文";
    // 标记CODE下标
    // var m_ui_code_id_idx = -1;
    // 单条数据
    var construct_item = function () { };

    // const
    var M_CONST_CODE_ID = "CODE";

    load_file();
    function load_file() {
        $.ajax({
            url: "/asset/lang_error_code.csv",
            method: "get",
            async: false,
            success: function (str_txt) {
                if ("string" === typeof str_txt) {
                    parse_txt(str_txt.replace(/(^\s*)|(\s*$)/g, ""));
                    // parse_txt(str_txt);
                }
            }
        });
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    解析翻译表.csv文件返回数据
     * 参数:
     *    @param { Promise<String> } str_txt 翻译表.csv文件返回字符串
     * 返回:
     *    @returns { Promise<Boolean> } 解析成功 || 格式错误
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-07-17
     *       内容 : 所有代码
    ************************************************************************************************/
    function parse_txt(str_txt) {
        var arr_txt_data = Papa.parse(str_txt).data;

        if ("object" !== typeof arr_txt_data || !arr_txt_data.length) {
            return false;
        }

        m_arr_header = JSON.parse(JSON.stringify(arr_txt_data[0]).toLocaleUpperCase().replace(/\s+/g,""));

        if (2 > m_arr_header.length) {
            return false;
        }

        var ui_data_len = arr_txt_data.length;

        for (var ui_data_i = 1; ui_data_i < ui_data_len; ui_data_i++) {
            var data_i = arr_txt_data[ui_data_i];

            if (!data_i || 2 > data_i.length) {
                continue;
            }

            var obj = new construct_item();

            for (var ui_item_i = 0; ui_item_i < data_i.length; ui_item_i++) {
                var str_head_i = m_arr_header[ui_item_i];
                var str_i = data_i[ui_item_i];

                if (str_head_i && (str_head_i = str_head_i.trim()) && str_i) {
                    obj[str_head_i.toLocaleUpperCase()] = str_i.trim();
                    if (str_head_i === M_CONST_CODE_ID) {
                        m_obj_map[str_i.trim()] = obj;
                    }
                }
            }
        }

        return true;
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    构造数据map
     * 参数:
     *    NA
     * 返回:
     *    @returns { Promise<Object> } 数据map || {}
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-07-17
     *       内容 : 所有代码
    ************************************************************************************************/
    function construct_data_map() {
        if (!m_str_cur_lang_type) {
            return {};
        }
        var obj_map = {};

        for (var key in m_obj_map) {
            if (Object.hasOwnProperty.call(m_obj_map, key)) {
                var value = m_obj_map[key];

                if (value) {
                    obj_map[key] = value[m_str_cur_lang_type];
                }
            }
        }

        return obj_map;
    }

    /************************************************************************************************
     * 类型:
     *    接口
     * 功能:
     *    设置当前页面切换的语言类型; 默认"中文"
     * 参数:
     *    @param { Promise<String> } str_type 当前语言类型; 字符串必须与表头的语言类型一致;
     * 返回:
     *    @returns { Promise<Boolean> } 设置成功 || 参数错误 || 当前语言表没有改类型则也会返回错误
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-07-17
     *       内容 : 所有代码
    ************************************************************************************************/
    this.set_lang_type = function (str_type) {
        if ("string" !== typeof str_type || !(str_type = str_type.trim().toLocaleUpperCase())) {
            return false;
        }

        if (-1 === m_arr_header.indexOf(str_type)) {
            return false;
        }

        m_str_cur_lang_type = str_type;
        return true;
    };


    /************************************************************************************************
     * 类型:
     *    接口
     * 功能:
     *    获取单条错误码的翻译
     * 参数:
     *    @param { Promise<String> } str_error_code 错误码
     * 返回:
     *    @returns { Promise<String> } 参数错误码相应的翻译 || false
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-07-17
     *       内容 : 所有代码
    ************************************************************************************************/
    this.get_item_value = function (str_error_code) {
        if ("string" !== typeof str_error_code || !(str_error_code = str_error_code.trim())) {
            return false;
        }

        if (!m_obj_map[str_error_code]) {
            return false;
        }

        return m_obj_map[str_error_code][m_str_cur_lang_type];
    };

    /************************************************************************************************
     * 类型:
     *    接口
     * 功能:
     *    获取当前语言类型的错误码数据对象map
     * 参数:
     *    NA
     * 返回:
     *    @returns { Promise<Object> } 所有错误码数据对象; 格式 = { 错误码: 翻译值 }
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-07-17
     *       内容 : 所有代码
    ************************************************************************************************/
    this.get_map = function () {
        return construct_data_map();
    };
}


